# DO NOT EDIT THIS FILE!
#
# This file is generated from the CDP specification. If you need to make
# changes, edit the generator and regenerate all of the modules.
#
# CDP domain: PWA (experimental)
from __future__ import annotations
from .util import event_class, T_JSON_DICT
from dataclasses import dataclass
import enum
import typing

@dataclass
class FileHandlerAccept:
    '''
    The following types are the replica of
    https://crsrc.org/c/chrome/browser/web_applications/proto/web_app_os_integration_state.proto;drc=9910d3be894c8f142c977ba1023f30a656bc13fc;l=67
    '''
    #: New name of the mimetype according to
    #: https://www.iana.org/assignments/media-types/media-types.xhtml
    media_type: str

    file_extensions: typing.List[str]

    def to_json(self):
        json = dict()
        json['mediaType'] = self.media_type
        json['fileExtensions'] = [i for i in self.file_extensions]
        return json

    @classmethod
    def from_json(cls, json):
        return cls(
            media_type=str(json['mediaType']),
            file_extensions=[str(i) for i in json['fileExtensions']],
        )


@dataclass
class FileHandler:
    action: str

    accepts: typing.List[FileHandlerAccept]

    display_name: str

    def to_json(self):
        json = dict()
        json['action'] = self.action
        json['accepts'] = [i.to_json() for i in self.accepts]
        json['displayName'] = self.display_name
        return json

    @classmethod
    def from_json(cls, json):
        return cls(
            action=str(json['action']),
            accepts=[FileHandlerAccept.from_json(i) for i in json['accepts']],
            display_name=str(json['displayName']),
        )


def get_os_app_state(
        manifest_id: str
    ) -> typing.Generator[T_JSON_DICT,T_JSON_DICT,typing.Tuple[int, typing.List[FileHandler]]]:
    '''
    Returns the following OS state for the given manifest id.

    :param manifest_id: The id from the webapp's manifest file, commonly it's the url of the site installing the webapp. See https://web.dev/learn/pwa/web-app-manifest.
    :returns: A tuple with the following items:

        0. **badgeCount** - 
        1. **fileHandlers** - 
    '''
    params: T_JSON_DICT = dict()
    params['manifestId'] = manifest_id
    cmd_dict: T_JSON_DICT = {
        'method': 'PWA.getOsAppState',
        'params': params,
    }
    json = yield cmd_dict
    return (
        int(json['badgeCount']),
        [FileHandler.from_json(i) for i in json['fileHandlers']]
    )
