# MS Windows Controls
  
Module to control MS Windows applications  

*Read this in other languages: [English](README.md), [Português](README.pr.md), [Español](README.es.md)*

## How to install this module
  
To install the module in Rocketbot Studio, it can be done in two ways:
1. Manual: __Download__ the .zip file and unzip it in the modules folder. The folder name must be the same as the module and inside it must have the following files and folders: \__init__.py, package.json, docs, example and libs. If you have the application open, refresh your browser to be able to use the new module.
2. Automatic: When entering Rocketbot Studio on the right margin you will find the **Addons** section, select **Install Mods**, search for the desired module and press install.  


## Overview


1. WindowScope  
A container that enables you to attach to an already opened window and perform multiple actions within it. This activity is also automatically generated when using the Desktop recorder. The application that you want to automate should be opened prior to executing the activity.

2. Element screenshot  
Takes a screenshot of the element and saves it in the specified directory.

3. Click  
Clicks a specified UI element.

4. Relative click  
Clicks with coordinates relative to a specified UI element.

5. Get Text  
Extracts a text value from a specified UI element.

6. Set Text  
Enables you to write a string to the Text attribute of a specified UI element.

7. Send Keys  
Enables you to write a string to the Text attribute of a specified UI element.

8. ComboBox  
Selects an item from a combo box or list box.

9. Wheel  
Simulate mouse wheel.

10. Extract Table  
Extract cell values of a table from a specified UI element.

11. Wait object  
Wait for a object on screen

12. Get Handle from Open windows  
return and array with name and handle tuple from Open Window

13. Read list  
Extract cell values of a list from a specified UI element.

14. Find child selector by  
Search all child by any property and return selectors

15. Get CheckBox state  
Get Default Action State from checkbox

16. Object is enabled  
Return True or False if object is enabled

17. Drag and Drop  
Drag and drop an object from coordinates or the object selector, both source and destination

18. Get Position  
Returns the coordinates of the specified element. You can choose to move the mouse to the position  



### Changes
Thu Jun 11 13:14:37 2020  Merge branch master of https://github.com/rocketbot-cl/WindowsControl
Tue Feb 25 12:31:14 2020  -
Thu Jan 9 14:29:50 2020  Merge branch master of https://github.com/rocketbot-cl/WindowsControl

----
### OS

- windows

### Dependencies

### License
  
![MIT](https://camo.githubusercontent.com/107590fac8cbd65071396bb4d04040f76cde5bde/687474703a2f2f696d672e736869656c64732e696f2f3a6c6963656e73652d6d69742d626c75652e7376673f7374796c653d666c61742d737175617265)  
[MIT](http://opensource.org/licenses/mit-license.ph)