## How to use this module
To use this module, you must complete the following setup:
1. __Login__ or __Sign up__ at https://developers.facebook.com/
2. Go to your Apps at https://developers.facebook.com/apps/ and click the Create App button.
3. Connect the business portfolio, which is the Facebook business account to which the App will be linked. Click Next.
4. On the next page What do you want your app to do? choose the Other option from the Looking for something else? section. Click Next.
5. Select the Business app type and click Next.
6. Choose the name, administrator email, and Business Account to which the App will be linked. Click Create, and you will be asked to enter your password to finish. When you create the App, you will be redirected to the App page, which will be in Development mode.
7. On this page, select the __Setup__ button in the Whatsapp app and then click __Start using the API__ under API Settings. You will be given a test number to send messages and up to 5 contacts that you can add to receive test messages. In both the development and production App, you can only send messages that include text to conversations that have been started by the user. If the conversation is started by the company, you must send templates that have been approved by META. For more information, check the following link: https://developers.facebook.com/docs/whatsapp/api/messages/message-templates
8. On the API Settings page, you will see a temporary access token to use the API. This token lasts for 24 hours. If you want to use the API for longer, you must request a permanent access token (See point 13). 9. In Step 1 of this page you will have access to the WhatsApp test number and the recipient number settings. You also have the Phone Number Identifier. Both this data and the token will be necessary to be able to connect through the module in developer mode.
10. Try to associate a recipient and send from the module the default template hello_world with the language en_US. If everything works correctly, you will receive a WhatsApp message with the text "Hello World!".
11. Once you have verified the operation, you can create your own templates that need to be approved by META and send them through the module. For more information about the templates, check the following link: https://developers.facebook.com/docs/whatsapp/api/messages/message-templates
12. Once you have verified the operation of the API, you must add a phone number for your company to be able to send messages to your clients. In step 5 of the API Configuration page, click on the __Add phone number__ button and follow the steps to create the WhatsApp Business profile. Once added, save the Phone Number Identifier, this information will be necessary to be able to connect through the module.
13. Once you have added a phone number, you need to configure the application to go into production mode and generate a permanent access token. To do this, you must go to the App page at https://developers.facebook.com/apps/ and select the App you created. On the App page, select the "Basic" option in App Configuration.
14. There you must provide a mandatory __Privacy Policy URL__ and the rest of the fields as optional. When you finish, click on __Save changes__.
15. With everything already configured, the app is ready to go into Active mode. To do this, go to the top of the web and move the Development selector to Active.
16. Get a permanent token: To do this, you must have a Meta business account. Go to https://business.facebook.com/ and in the menu on the left select your company, and click on the configuration wheel, then on Business Settings. In the new window go to Users > System Users and add a new user.
17. Accept the message in the window that opens and then select a name for your new user. In Role you must put Administrator.
18. When creating the user, click on the __Assign assets__ button. In the window that will open, select Apps, then select the App you created and activate the __Manage App__ option, then Save changes.
19. When assigning the asset, click on __Generate new token__. Select your App, in __Token expiration__ choose __Never__ and check all the permissions on the list (not all of them are necessary but if more integrations are added to Rocketbot in the future you will be able to use the same credential). Click on __Generate token__. This will be the permanent token that you can use to authenticate to the module.

---

## Como usar este módulo
Para utilizar este módulo, se debe realizar la siguiente configuración:
1. __Inicia sesión__ o __regístrate__ en https://developers.facebook.com/
2. Ve a tus Apps en https://developers.facebook.com/apps/ y haz click en el botón Crear App. 
3. Conectar el porfolio comercial que es la cuenta comercial de Facebook a la que se vinculará la App. Haz click en siguiente.
4. En la página siguiente ¿Qué quieres que haga tu app? elegir la opción Otro de la sección ¿Buscas otra cosa? Haz click en siguiente.
5. Selecciona el tipo de app Negocios y haz click en siguiente.
6. Elije el nombre, el correo del administrador y la Cuenta comercial a la que se vinculará la App. Click en Crear, y se te pedirá insertar tu contraseña para terminar. Al crear la App, se te redirigirá a la página de la misma, la cual se encontrará en modo Desarrollo.
7. En esta página, selecciona en la app Whatsapp el botón __Configurar__ y luego en Configuración de la API haz click en __Empezar a usar la API__. Se te otorgará un número de prueba para enviar mensajes y hasta 5 contactos que puedes agregar para recibir los mensajes de prueba. Tanto en la App en desarrollo como en producción, sólo puedes enviar mensajes que incluyen texto a conversaciones que hayan sido iniciadas por el usuario. Si la conversación es iniciada por la empresa, deberás enviar plantillas que hayan sido aprobadas por META. Para más información revisa el siguiente link: https://developers.facebook.com/docs/whatsapp/api/messages/message-templates
8. En la página de Configuración de la API verás un token de acceso temporal para usar la API. Este token tiene una duración de 24 horas. Si quieres usar la API por más tiempo, debes solicitar un token de acceso permanente (Ver punto 13).
9. En el Paso 1 de esta página tendrás acceso al número de prueba de Whatsapp y a la configuración de los números de destinatario. También tienes el Identificador de número de teléfono. Tanto este dato como el token serán necesarios para poder conectarte a través del módulo en modo desarrollador. 
10. Prueba asociar un destinatario y enviar desde el módulo la plantilla por defecto hello_world con el lenguaje en_US. Si todo funciona correctamente, recibirás un mensaje de Whatsapp con el texto "Hello World!".
11. Una vez comprobado el funcionamiento, puedes crear tus propias plantillas que necesitan ser aprobadas por META y enviarlas a través del módulo. Para más información sobre las plantillas, revisa el siguiente link: https://developers.facebook.com/docs/whatsapp/api/messages/message-templates
12. Una vez que hayas comprobado el funcionamiento de la API, deberás agregar un número de teléfono de tu empresa para poder enviar mensajes a tus clientes. En el paso 5 de la pagina Configuración de la API haz click en el botón __Agregar número de teléfono__ y sigue los pasos para crear el perfil de Whatsapp Business. Una vez agregado, guarda el Identificador de número de teléfono, este dato será necesario para poder conectarte a través del módulo.
13. Al tener un número de teléfono agregado, queda configurar la aplicación para pasar al modo productivo y generar un token de acceso permanente. Para esto, debes ir a la página de la App en https://developers.facebook.com/apps/ y seleccionar la App que creaste. En la página de la App, selecciona en Configuración de la App la opción "Básica".
14. Allí deberás otorgar una __URL de la Política de privacidad__ de forma obligatoria y el resto de campos de forma opcional. Al finalizar haz click en __Guardar cambios__.
15. Con todo ya configurado, la app está lista para pasar al modo Activo. Para ello ve hacia arriba de todo en la web y mueve el selector de Desarrollo a Activo. 
16. Obtener token permanente: Para ello debes tener una cuenta comercial de Meta. Ingresa a https://business.facebook.com/ y en el menú de la izquierda selecciona tu empresa, y haz click en la rueda de configuración, luego en Configuración de negocio. En la nueva ventana dirígete a Usuarios > Usuarios del sistema y agrega un usuario nuevo.
17. Acepta el mensaje de la ventana que se abre y luego selecciona un nombre para tu nuevo usuario. En Rol debes colocar Administrador.
18. Al crear el usuario haz click en el botón __Asignar activos__. En la ventana que se abrirá selecciona Apps, luego marca la App que creaste y activa la opción __Administrar App__, luego Guarda los cambios.
19. Al asignar el activo, haz click en __Generar nuevo token__. Selecciona tu App, en __Caducidad del token__ elige __Nunca__ y marca todos los permisos de la lista (no son todos necesarios pero si en un futuro se agregan más integraciones en Rocketbot podrás utilizar la misma credencial). Haz click en __Generar token__. Este será el token permanente que podrás utilizar para autenticarte en el módulo.

---

## Como usar este módulo
Para utilizar este módulo, deve-se fazer a seguinte configuração:
1. __Login__ ou __register__ em https://developers.facebook.com/
2. Acesse seus aplicativos em https://developers.facebook.com/apps/ e clique no botão Criar aplicativo.
3. Conecte a carteira comercial, que é a conta comercial do Facebook à qual o App estará vinculado. Clique em próximo.
4. Na próxima página, o que você deseja que seu aplicativo faça? escolha a opção Outro em Você está procurando outra coisa? Clique em próximo.
5. Selecione o tipo de aplicativo Business e clique em Avançar.
6. Escolha o nome, e-mail do administrador e conta comercial à qual o aplicativo será vinculado. Clique em Criar e será solicitado que você insira sua senha para finalizar. Ao criar o App, você será redirecionado para a página dele, que estará em modo Desenvolvimento.
7. Nesta página, selecione o botão __Configurar__ no aplicativo Whatsapp e depois em Configurações da API clique em __Começar a usar a API__. Você receberá um número de teste para enviar mensagens e até 5 contatos que poderá adicionar para receber as mensagens de teste. Tanto no App em desenvolvimento quanto em produção, você só pode enviar mensagens que incluam texto para conversas iniciadas pelo usuário. Caso a conversa seja iniciada pela empresa, você deverá enviar modelos que tenham sido aprovados pela META. Para mais informações consulte o seguinte link: https://developers.facebook.com/docs/whatsapp/api/messages/message-templates
8. Na página Configurações da API você verá um token de acesso temporário para usar a API. Este token dura 24 horas. Se quiser utilizar a API por mais tempo, deverá solicitar um token de acesso permanente (ver ponto 13).
9. No Passo 1 desta página você terá acesso ao número de teste do Whatsapp e às configurações do número do destinatário. Você também tem o identificador do número de telefone. Tanto esta informação quanto o token serão necessários para poder conectar-se através do módulo no modo de desenvolvedor.
10. Tente associar um destinatário e enviar do módulo o modelo padrão hello_world com o idioma en_US. Se tudo funcionar corretamente, você receberá uma mensagem no WhatsApp com o texto “Olá, Mundo!”.
11. Depois de funcionar, você pode criar seus próprios templates que precisam ser aprovados pelo META e enviá-los através do módulo. Para mais informações sobre templates, confira o seguinte link: https://developers.facebook.com/docs/whatsapp/api/messages/message-templates
12. Depois de verificar se a API funciona, você precisará adicionar um número de telefone da sua empresa para poder enviar mensagens aos seus clientes. No passo 5 da página Configuração da API, clique no botão __Adicionar número de telefone__ e siga os passos para criar o perfil do WhatsApp Business. Uma vez adicionado, salve o Identificador do Número de Telefone, esta informação será necessária para poder se conectar através do módulo.
13. Adicionado um número de telefone, resta configurar o aplicativo para entrar em modo produtivo e gerar um token de acesso permanente. Para fazer isso, você deve ir até a página do App em https://developers.facebook.com/apps/ e selecionar o App que você criou. Na página do aplicativo, selecione a opção "Básico" nas configurações do aplicativo.
14. Lá você deve fornecer um __URL da Política de Privacidade__ obrigatório e o restante dos campos opcionalmente. Ao terminar, clique em __Salvar alterações__.
15. Com tudo já configurado, o app está pronto para entrar no modo Ativo. Para fazer isso, vá até o topo de tudo no site e mova o seletor Desenvolvimento para Ativo.
16. Obtenha token permanente: Para fazer isso, você deve ter uma conta de negociação Meta. Acesse https://business.facebook.com/ e no menu à esquerda selecione sua empresa, e clique na roda de configuração e depois em Configuração empresarial. Na nova janela vá para Usuários > Usuários do Sistema e adicione um novo usuário.
17. Aceite a mensagem na janela que se abre e selecione um nome para o seu novo usuário. Em Função você deve colocar Administrador.
18. Ao criar o usuário, clique no botão __Assign Assets__. Na janela que se abrirá, selecione Apps, marque o App que você criou e ative a opção __Gerenciar App__, depois Salve as alterações.
19. Ao atribuir o ativo, clique em __Gerar novo token__. Selecione seu App, em __Token Expiration__ escolha __Nunca__ e verifique todas as permissões da lista (nem todas são necessárias, mas se mais integrações forem adicionadas ao Rocketbot no futuro você poderá usar a mesma credencial). Clique em __Gerar token__. Este será o token permanente que você pode usar para autenticar no módulo.
