# Java Recorder
With Java Recorder you can record clicks to automate applications developed in Java.

<img src="https://i.imgur.com/aOGqPqL.png"/>

## Available events:
- Rec: Record a sequence of clicks until you press ESC.
- Click: Record click on an object.
- GetText: Record the object to get the text.
- SetText: Record an object and sends text.
- Save: Save the robot in JSON.
- Trash: Remove the entire robot.
- Trash Event: Delete the event.
- Copy Selector: The selector is copied to the clipboard.


## Getting started
These instructions will get you a copy of the project up and running on your local machine for development and testing purposes.

### Prerrequisitos

What things you need to install Java Recorder and how to install them

```
Python 3
```

The `pip` package management tool

Install the dependencies contained in `requirements.txt`

```
pip install -r requirements.txt
```

### Installing

You only have to run the `__init__.py` file: :

```
python __init__.py
```

## Updates

- 5/11/2020 - Add a new way to find Java components.

## Built With

- [pyautogui](https://pyautogui.readthedocs.io/en/latest/) - PyAutoGUI lets your Python scripts control the mouse and keyboard to automate interactions with other applications..
- [pynput](https://pynput.readthedocs.io/en/latest/) - This library allows you to control and monitor input devices.
- [bottle](https://bottlepy.org/docs/dev/) - Bottle is a fast, simple and lightweight WSGI micro web-framework for Python.
- [pywin32](https://github.com/mhammond/pywin32) - Python extensions for Microsoft Windows Provides access to much of the Win32 API, the ability to create and use COM objects, and the Pythonwin environment.


## Authors

- **Nicolás Liendro** - _Initial work_ - [GitLab](https://gitlab.com/NicoLiendro14),
  [GitHub](https://github.com/NicoLiendro14) and
  [LinkedIn](https://www.linkedin.com/in/nicol%C3%A1s-liendro-00248a178/)


