/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.nodes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.piccolo2d.PNode;
import org.piccolo2d.util.PPaintContext;

public abstract class PShape
extends PNode {
    private transient Stroke stroke = DEFAULT_STROKE;
    private Paint strokePaint = DEFAULT_STROKE_PAINT;
    private transient boolean updatingBoundsFromShape = false;
    public static final Paint DEFAULT_PAINT = Color.WHITE;
    public static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);
    public static final Paint DEFAULT_STROKE_PAINT = Color.BLACK;

    protected PShape() {
        this.setPaint(DEFAULT_PAINT);
    }

    protected abstract Shape getShape();

    protected abstract void transform(AffineTransform var1);

    public final Stroke getStroke() {
        return this.stroke;
    }

    public final void setStroke(Stroke stroke) {
        Stroke oldStroke = this.stroke;
        this.stroke = stroke;
        this.updateBoundsFromShape();
        this.invalidatePaint();
        this.firePropertyChange(-1, "stroke", oldStroke, this.stroke);
    }

    public final Paint getStrokePaint() {
        return this.strokePaint;
    }

    public final void setStrokePaint(Paint strokePaint) {
        Paint oldStrokePaint = this.strokePaint;
        this.strokePaint = strokePaint;
        this.invalidatePaint();
        this.firePropertyChange(-1, "strokePaint", oldStrokePaint, this.strokePaint);
    }

    protected final void updateBoundsFromShape() {
        this.updatingBoundsFromShape = true;
        Rectangle2D b = this.getBoundsWithStroke();
        this.setBounds(b.getX(), b.getY(), b.getWidth(), b.getHeight());
        this.updatingBoundsFromShape = false;
    }

    protected final Rectangle2D getBoundsWithStroke() {
        if (this.stroke != null) {
            return this.stroke.createStrokedShape(this.getShape()).getBounds2D();
        }
        return this.getShape().getBounds2D();
    }

    protected final void internalUpdateBounds(double x, double y, double width, double height) {
        if (this.updatingBoundsFromShape) {
            return;
        }
        Rectangle2D bounds = this.getShape().getBounds2D();
        Rectangle2D strokeBounds = this.getBoundsWithStroke();
        double strokeOutset = Math.max(strokeBounds.getWidth() - bounds.getWidth(), strokeBounds.getHeight() - bounds.getHeight());
        double adjustedX = x + strokeOutset / 2.0;
        double adjustedY = y + strokeOutset / 2.0;
        double adjustedWidth = width - strokeOutset;
        double adjustedHeight = height - strokeOutset;
        double scaleX = adjustedWidth == 0.0 || bounds.getWidth() == 0.0 ? 1.0 : adjustedWidth / bounds.getWidth();
        double scaleY = adjustedHeight == 0.0 || bounds.getHeight() == 0.0 ? 1.0 : adjustedHeight / bounds.getHeight();
        AffineTransform transform = new AffineTransform();
        transform.translate(adjustedX, adjustedY);
        transform.scale(scaleX, scaleY);
        transform.translate(-bounds.getX(), -bounds.getY());
        this.transform(transform);
    }

    public final boolean intersects(Rectangle2D bounds) {
        if (super.intersects(bounds)) {
            if (this.getPaint() != null && this.getShape().intersects(bounds)) {
                return true;
            }
            if (this.stroke != null && this.strokePaint != null) {
                return this.stroke.createStrokedShape(this.getShape()).intersects(bounds);
            }
        }
        return false;
    }

    protected void paint(PPaintContext paintContext) {
        Paint p = this.getPaint();
        Graphics2D g2 = paintContext.getGraphics();
        if (p != null) {
            g2.setPaint(p);
            g2.fill(this.getShape());
        }
        if (this.stroke != null && this.strokePaint != null) {
            g2.setPaint(this.strokePaint);
            g2.setStroke(this.stroke);
            g2.draw(this.getShape());
        }
    }
}

