



# Google SpreadSheet
  
This module allows you to read, write and update Google spreadsheets. You can add, delete, duplicate or even hide sheets; filter data; add or delete rows and columns; modify cells format, copy/cut and paste them; and more.  

*Read this in other languages: [English](README.md), [Português](README.pr.md), [Español](README.es.md)*

## How to install this module
  
To install the module in Rocketbot Studio, it can be done in two ways:
1. Manual: __Download__ the .zip file and unzip it in the modules folder. The folder name must be the same as the module and inside it must have the following files and folders: \__init__.py, package.json, docs, example and libs. If you have the application open, refresh your browser to be able to use the new module.
2. Automatic: When entering Rocketbot Studio on the right margin you will find the **Addons** section, select **Install Mods**, search for the desired module and press install.  


## Overview


1. Setup G-Suite credentials  
Get permissions to handle Google SpreadSheet with Rocketbot

2. Login without json file  
Login to Google Drive without json file

3. Create SpreadSheet  
Create a new spreadsheet in Google SpreadSheet

4. Create Sheet  
Create a new sheet in selected SpreadSheet

5. Update Sheet properties  
Update a sheet properties from selected SpreadSheet

6. Delete Sheet  
Delete a sheet from selected SpreadSheet

7. Write cells  
Write to a cell or range of cells in the selected Spreadsheet

8. Format cells  
Change format of a cell or range of cells in the selected Spreadsheet

9. Read cells  
Read a cell or range of cells from the selected Spreadsheet, example A1 or A1:B5

10. Copy/Cut and paste  
Copy or cut and paste a cell or range of cells in the selected Spreadsheet

11. Get sheets  
Get list of sheets with their ID of the selected Spreadsheet

12. Count rows and/or columns  
Count the used rows and/or columns of the selected sheet

13. Add column  
Add Columns to Selected Spreadsheet

14. Add row  
Add rows to the selected Spreadsheet

15. Delete column  
Delete a column from a selected Spreadsheet

16. Delete row  
Delete a row from a selected Spreadsheet

17. Filter data  
Filter data in the selected Spreadsheet

18. Unfilter data  
Unfilter data in the selected Spreadsheet

19. Get filtered cells  
Get the filtered cells

20. Duplicate sheet  
Duplicates the selected sheet to the same or another workbook

21. Text to columns  
Splits a column of text into multiple columns, based on a delimiter in each cell.  




----
### OS

- windows
- mac
- linux
- docker

### Dependencies
- [**google-api-python-client**](https://pypi.org/project/google-api-python-client/)- [**google-auth-httplib2**](https://pypi.org/project/google-auth-httplib2/)- [**google-auth-oauthlib**](https://pypi.org/project/google-auth-oauthlib/)- [**gspread**](https://pypi.org/project/gspread/)
### License
  
![MIT](https://camo.githubusercontent.com/107590fac8cbd65071396bb4d04040f76cde5bde/687474703a2f2f696d672e736869656c64732e696f2f3a6c6963656e73652d6d69742d626c75652e7376673f7374796c653d666c61742d737175617265)  
[MIT](http://opensource.org/licenses/mit-license.ph)